<?php
   /*
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    */

    include "../include/costanti.php";
    include "../include/util.php";
    include "../gUtil/DbManager.php";
    include "../gUtil/GestoreUpload.php";
    include "../classi/Documento.php";
    include "../classi/GestoreStoricoOperazioni.php";
    include "../classi/GeneratoreUrl.php";
    include "../classi/Notifica.php";
     
    //i dati del database sono definiti nel file costanti.php
    $geecomDb     = new DbManager($costantiDatabase);
    $impostazioni = recuperaImpostazioni($geecomDb);
    $gestoreStoricoOperazioni = new GestoreStoricoOperazioni($geecomDb,"Doc");
    
    // la dimensione massima dei file è data dallo spazio residuo rimasto
    $dimensioneMassimaFileInMb = calcoloSpazioResiduo($geecomDb);
            
    session_start();
    controlloAccessoAdmin();
    
    if(isset($_GET["operazione"])) {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
        $idRisorsa   = isset($_GET["id"]) ? filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT) : 0;
    }
    else {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
        $idRisorsa   = isset($_POST["id"]) ? filter_input(INPUT_POST,"id",FILTER_SANITIZE_NUMBER_INT) : 0;
    }
    
    $documento = new Documento($geecomDb, $idRisorsa);
    
    // dato che serve in molti switch per capire la pagina a cui l'utente deve essere rediretto
    $datiProdottoGeecom = $geecomDb->leggiSingolaRiga("geec_prodotti", 3) ;
    $percorsoGeecomDoc  = GeneratoreUrl::creaUrlAreaAmministrativa($impostazioni,$datiProdottoGeecom);
    
    // dato che serve in molti switch per capire la pagina a cui l'utente deve essere rediretto
    $datiGeecomAdmin         = $geecomDb->leggiSingolaRiga("geec_prodotti", 2) ;
    $urlAreaAmministrativa = str_replace("../","",$datiGeecomAdmin["percorso"]);
    switch ($operazione) {
        case 'crea':
            $prefissoFile = uniqid();
            if($_FILES['file']['name']!="") {  // il codice viene eseguito solo se c'è un file
                $tipiFileAmmessi = array("image/png","image/jpeg","image/gif","application/pdf",'application/msword',"application/vnd.openxmlformats-officedocument.wordprocessingml.document","application/vnd.ms-excel","application/vnd.openxmlformats-officedocument.spreadsheetml.sheet","application/vnd.ms-powerpoint","application/vnd.oasis.opendocument.text","application/vnd.oasis.opendocument.spreadsheet","application/zip","application/x-rar-compressed","audio/mpeg","application/ogg","video/mp4","video/ogg","video/webm","application/pkcs7-mime","application/x-pkcs7-mime");
                $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, $dimensioneMassimaFileInMb, "../file/documenti", 0, $prefissoFile);
                $esitoUpload  = $gestoreUpload->salvaFile();
                if($esitoUpload["fileElaborati"]==1 && $esitoUpload["percorso"]=="") {
                    echo $esitoUpload["errore"];
                    exit();
                }
                else if($esitoUpload["fileElaborati"]==1){
                    $percorsoFile = str_replace("../","",$esitoUpload["percorso"]);

                    $documento->setCartella(filter_input(INPUT_POST,"idCartella",FILTER_SANITIZE_NUMBER_INT));
                    $documento->setUtente($_SESSION["geecomAdmin_id"]);
                    $documento->setNome(str_replace("file/documenti/$prefissoFile","",$percorsoFile));
                    $documento->setPercorso($percorsoFile);
                    $idDocumentoCreato = $documento->crea();
                    $dimensioneFile = filesize("../".$percorsoFile)/1000000;
                    $documento->aggiungiVersione($_SESSION["geecomAdmin_nome"],$percorsoFile,$dimensioneFile);
                    $gestoreStoricoOperazioni->aggiungiElemento("creazioneDocumento", $_SESSION["geecomAdmin_nome"]." ha creato una nuovo documento");

                    if($impostazioni["inviaNotificaNuovoDocumento"]=="si" && $_SESSION["geecomAdmin_ruolo"]!="super admin") {
                        $notifica = new Notifica($geecomDb, 0);
                        $notifica->setProdotto("Doc");
                        $notifica->setTesto($_SESSION["geecomAdmin_nomeCognome"]." ha creato un nuovo documento");
                        $notifica->setLink("dettagliDocumento.php?id=$idDocumentoCreato");
                        $notifica->crea();
                    }
                }
                else { // sono stati caricati più file
                    foreach($esitoUpload["elencoRisultati"] as $fileElaborato) {
                        $percorsoFile = str_replace("../","",$fileElaborato["percorso"]);

                        $documento->setCartella(filter_input(INPUT_POST,"idCartella",FILTER_SANITIZE_NUMBER_INT));
                        $documento->setUtente($_SESSION["geecomAdmin_id"]);
                        $documento->setNome(str_replace("file/documenti/$prefissoFile","",$percorsoFile));
                        $documento->setPercorso($percorsoFile);
                        $idDocumentoCreato = $documento->crea();
                        $dimensioneFile = filesize("../".$percorsoFile)/1000000;
                        $documento->aggiungiVersione($_SESSION["geecomAdmin_nome"],$percorsoFile,$dimensioneFile);
                        $gestoreStoricoOperazioni->aggiungiElemento("creazioneDocumento", $_SESSION["geecomAdmin_nome"]." ha creato una nuovo documento");

                        if($impostazioni["inviaNotificaNuovoDocumento"]=="si" && $_SESSION["geecomAdmin_ruolo"]!="super admin") {
                            $notifica = new Notifica($geecomDb, 0);
                            $notifica->setProdotto("Doc");
                            $notifica->setTesto($_SESSION["geecomAdmin_nomeCognome"]." ha creato un nuovo documento");
                            $notifica->setLink("dettagliDocumento.php?id=$idDocumentoCreato");
                            $notifica->crea();
                        }
                    }
                }
            }
            echo "ok";
            break;
        case 'modifica':
            $documento->caricaDatiDalDatabase();
            $documento->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $documento->setDescrizione(filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_STRING));
            $documento->modifica();
            $gestoreStoricoOperazioni->aggiungiElemento("modificaDocumento", $_SESSION["geecomAdmin_nome"]." ha modificato il documento ".$documento->getNome());
            header("Location: $percorsoGeecomDoc/dettagliDocumento.php?id={$documento->getId()}&status=200");
            break;
        case 'rinomina':
            $documento->setNome(filter_input(INPUT_POST,"nuovoNome",FILTER_SANITIZE_ADD_SLASHES));
            $documento->rinomina();
            echo "ok";
            break;
        case 'sposta':
            $documento->sposta(filter_input(INPUT_POST,"idCartella",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
        case 'aggiungiVersione':
            if($_FILES['file']['name']!="") {  // il codice viene eseguito solo se c'è un file
                $prefissoFile = uniqid();
                $tipiFileAmmessi = array("image/png","image/jpeg","image/gif","application/pdf",'application/msword',"application/vnd.openxmlformats-officedocument.wordprocessingml.document","application/vnd.ms-excel","application/vnd.openxmlformats-officedocument.spreadsheetml.sheet","application/vnd.ms-powerpoint","application/vnd.oasis.opendocument.text","application/vnd.oasis.opendocument.spreadsheet","application/zip","application/x-rar-compressed","audio/mpeg","application/ogg","video/mp4","video/ogg","video/webm","application/pkcs7-mime","application/x-pkcs7-mime");
                $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, $dimensioneMassimaFileInMb, "../file/documenti", 0, $prefissoFile);
                $esitoUpload  = $gestoreUpload->salvaFile();
                if($esitoUpload["percorso"]=="") {
                    echo "Errore: file non ammesso";
                    exit();
                }
                else {
                    $percorsoFile = str_replace("../","",$esitoUpload["percorso"]);
                }
                
                $dimensioneFile = filesize("../".$percorsoFile)/1000000;
                $documento->aggiungiVersione($_SESSION["geecomAdmin_nome"],$percorsoFile,$dimensioneFile);
                
                // elimina vecchie versioni () se non funziona
                $numeroVersioni = $geecomDb->contaRigheTabella("geecD_versioniDocumento", ["idDocumento"=>$documento->getId()]);
                if($numeroVersioni>$impostazioni["numeroVersioniDocumento"]) {
                    $numeroVersioniDaCancellare = $numeroVersioni-$impostazioni["numeroVersioniDocumento"];
                    $queryDaCancellare    = "SELECT id FROM geecD_versioniDocumento WHERE idDocumento = {$documento->getId()} ORDER BY id ASC LIMIT $numeroVersioniDaCancellare";
                    $risQueryDaCancellare = $geecomDb->eseguiQueryLettura($queryDaCancellare);
                    while($versioneDaELiminare = $risQueryDaCancellare->fetch_assoc()) {
                        $geecomDb->eseguiQueryCancellazione("geecD_versioniDocumento", $versioneDaELiminare["id"]);
                    }
                }
                $documento->caricaDatiDalDatabase();
                $nomeDocumentoEscape = filter_var($documento->getNome(),FILTER_SANITIZE_ADD_SLASHES);
                $gestoreStoricoOperazioni->aggiungiElemento("aggiungiVersioneDocumento", $_SESSION["geecomAdmin_nome"]." ha aggiunto una nuova versione al documento $nomeDocumentoEscape");
                if($impostazioni["inviaNotificaNuovaVersioneDocumento"]=="si" && $_SESSION["geecomAdmin_ruolo"]!="super admin") {
                    $notifica = new Notifica($geecomDb, 0);
                    $notifica->setProdotto("Doc");
                    $notifica->setTesto($_SESSION["geecomAdmin_nomeCognome"]." ha aggiunto una nuova versione al documento $nomeDocumentoEscape");
                    $notifica->setLink("dettagliDocumento.php?id=".$documento->getId());
                    $notifica->crea();
                }
                echo "ok";
            }
            break;
        case 'eliminaAssociazioneEtichettaDocumento':
            $idEtichetta = filter_input(INPUT_POST, "idEtichetta",FILTER_SANITIZE_NUMBER_INT);
            $documento->eliminaAssociazioneEtichettaDocumento($idEtichetta);
            echo "ok";
            break;
        case 'associaDocumentoEtichetta':
            $idEtichetta = filter_input(INPUT_POST,"idEtichetta",FILTER_SANITIZE_NUMBER_INT);
            $queryTagEsistenti = "SELECT * FROM geecD_associazioneEtichetteDocumenti WHERE idDocumento = {$documento->getId()} AND idEtichetta = $idEtichetta";
            $risTagEsistenti   = $geecomDb->eseguiQueryLettura($queryTagEsistenti);
            if($risTagEsistenti->num_rows == 0) {
                $documento->creaAssociazioneEtichettaDocumento($idEtichetta);
                $etichetta = $geecomDb->leggiSingolaRiga("geecD_etichette", $idEtichetta);
                echo"<div id=\"divEtichetta{$idEtichetta}\" class=\"d-inline-block mr-2 mb-2\">
                        <button type=\"button\" class=\"btn btn-primary btn-sm round\" onclick=\"eliminaAssociazioneEtichettaDocumento({$idEtichetta})\">{$etichetta["nome"]}<i class=\"fas fa-times ml-2\"></i></button>
                    </div>";                
            }
            else {
                echo "Il documento è già associato a questa etichetta";
            }
            break;
        case 'associaDocumentoAPiuEtichette':
            $arrayTag = $_POST["etichetteDaAggiungere"];
            
            foreach($arrayTag as $idEtichetta) {
                $documento->creaAssociazioneEtichettaDocumento($idEtichetta);
            }
            header("Location: $percorsoGeecomDoc/dettagliDocumento.php?id={$documento->getId()}&status=250");
            break;
        case 'elimina':
            $documento->caricaDatiDalDatabase();
            $nomeDocumentoEscape = filter_var($documento->getNome(),FILTER_SANITIZE_ADD_SLASHES);
            $documento->elimina();
            $gestoreStoricoOperazioni->aggiungiElemento("eliminazioneDocumento", $_SESSION["geecomAdmin_nome"]." ha eliminato il nuovo documento $nomeDocumentoEscape");
            echo"ok";
            break;
        case 'eliminaVersione':
            $documento->caricaDatiDalDatabase();
            $nomeDocumentoEscape = filter_var($documento->getNome(),FILTER_SANITIZE_ADD_SLASHES);
            $idVersione = filter_input(INPUT_POST,"idVersione",FILTER_SANITIZE_NUMBER_INT);
            $documento->eliminaVersione($idVersione);
            $gestoreStoricoOperazioni->aggiungiElemento("eliminazioneDocumento", $_SESSION["geecomAdmin_nome"]." ha eliminato la versione con id $idVersione del documento $nomeDocumentoEscape");
            echo"ok";
            break;
        case 'eliminaMessaggiChat':
            $documento->eliminaMessaggiChat();
            echo"ok";
            break;
    }
    
    
    
    
